unit HtmlData;

interface

uses
  Classes, DB;

type
  THtmlStrings = class (TStringList)
  public
    procedure AddHeader (Title: string); virtual;
    procedure AddFooter; virtual;
  end;

  THtmlData = class (THtmlStrings)
  public
    constructor Create (DataSet: TDataSet);
    procedure AddHeader (Title: string); override;
    procedure AddFooter; override;
    procedure AddTableRow (LinkStr: string);
  private
    Data: TDataSet;
  end;

implementation

uses
  SysUtils;

////// THtmlStrings //////

procedure THtmlStrings.AddHeader (Title: string);
begin
  Clear;
  Add ('<HTML>');
  Add ('<HEAD>');
  Add ('<TITLE>' + Title + '</TITLE>');
  Add ('</HEAD>');
  Add ('<BODY>');
  Add ('<H1><CENTER>' + Title + '</CENTER></H1>');
end;

procedure THtmlStrings.AddFooter;
begin
  Add ('<HR>');
  Add ('Generated by the program ' +
    ExtractFileName (ParamStr(0)));
  Add ('</BODY>');
  Add ('</HTML>');
end;

////// THtlmData //////

constructor THtmlData.Create (DataSet: TDataSet);
begin
  inherited Create;
  Data := DataSet;
end;

procedure THtmlData.AddHeader (Title: string);
var
  I: Integer;
begin
  inherited AddHeader (Title);

  // start table with borders
  Add('<table border>');
  // new row, with the table headers (tag <th>) for the visible fields
  Add('<tr>');
  for I := 0 to Data.FieldCount - 1 do
    if Data.Fields[I].Visible then
      Add('<th>' + Data.Fields[I].FieldName + '</th>');
  Add('</tr>');
end;

procedure THtmlData.AddFooter;
begin
  // end the table
  Add('</table>');

  inherited AddFooter;
end;

procedure THtmlData.AddTableRow (LinkStr: string);
var
  I: Integer;
begin
  // new row, with table data (tag <td>)
  Add('<tr>');
  if LinkStr <> '' then
    // add a link
    Add('<td><a href="' + LinkStr +
      Data.Fields[0].DisplayText + '.htm">'
      + Data.Fields[0].DisplayText + '</a></td>')
  else
    // plain data
    Add('<td>' + Data.Fields[0].DisplayText + '</td>');

  // all the other visible fields
  for I := 1 to Data.FieldCount - 1 do
    if Data.Fields[I].Visible then
      if Data.Fields[I].DisplayText <> '' then
        Add('<td>' + Data.Fields[I].DisplayText + '</td>')
      else
        Add('<td><br></td>');
  Add('</tr>');
end;

end.
